var notiTriggers = document.getElementsByClassName('bh-notification-trigger'),
    notis = document.getElementsByClassName('bh-notification'),
    lastX = window.innerWidth,
    openNotiWidth,
    closeButtons = document.querySelectorAll('[bh-notification-close]');


var openNoti = function(notiID) {
    var noti = document.querySelector('#' + notiID),
        openNotis = document.querySelectorAll('.bh-notification.open');
    
    //close open notifications
    for (var j = 0; j < openNotis.length; j++) {
        openNotis[j].classList.remove('open');
        openNotis[j].setAttribute('aria-hidden', true);
    }

    //open clicked notification
    noti.classList.add('open');
    noti.setAttribute('aria-hidden', false);
    openNotiWidth = noti.offsetWidth + 10;

    //center notification
    if (!noti.classList.contains('bh-notification--full')) {
        var notiWidth = noti.offsetWidth + 10;
        noti.style.left = 'calc(50% - ' + (notiWidth * .5) + 'px)';
        resizeNotis();
    }

    //check for data attributes
    if (noti.hasAttribute('data-bh-noti-top')) {
        var topAmt = noti.getAttribute('data-bh-noti-top');
        noti.style.top = topAmt + 'px';
    }

    if (noti.hasAttribute('data-bh-noti-parent')) {
        var parentId = '#' + noti.getAttribute('data-bh-noti-parent');
        var parent = document.querySelector(parentId);
        parent.style.position = 'relative';
        noti.style.position = 'absolute';
        parent.appendChild(noti);
    } else {
        document.body.appendChild(noti);
        noti.style.position = 'fixed';
    }

    if (noti.hasAttribute('data-bh-noti-timeout')) {
        var timeoutAmt = noti.getAttribute('data-bh-noti-timeout');
        setTimeout(function() {
            noti.classList.remove('open');
        }, timeoutAmt);
    }
}

for (var i = 0; i < notiTriggers.length; i++) {
    notiTriggers[i].addEventListener('click', function() {
        openNoti(this.getAttribute('data-noti-trigger'));
    });
}


var closeNoti = function(notiID) {
    var noti = document.querySelector('#' + notiID);
    noti.classList.remove('open');
    noti.setAttribute('aria-hidden', true);
}

closeButtons.forEach(function (closeButton) {
    closeButton.addEventListener('click', function(e) {
        const thisNoti = this.closest('.bh-notification').id;
        closeNoti(thisNoti);
    });
});

var resizeNotis = function() {
    var notis = document.querySelectorAll('.bh-notification.open:not(.bh-notification--full)'),
        x = window.innerWidth;

    for (var i = 0; i < notis.length; i++) {
        var n = notis[i].offsetWidth;

        if (lastX > x) { //resized down
            if ((x - 30) < n || x < 481) {
                notis[i].style.left = '10px';
                notis[i].style.width = 'calc(100% - 20px)';
            }
        } else { //resized up
            if ((x - 30) > openNotiWidth) {
                notis[i].style.width = (openNotiWidth + 10) + 'px';
                notis[i].style.left = 'calc(50% - ' + (openNotiWidth * .5) + 'px)';
            }
        }

        lastX = x;
    }
}

window.addEventListener('resize', resizeNotis);