(function () {
    {
        var unknown = '-';
  
        // browser
        var nVer = navigator.appVersion;
        var nAgt = navigator.userAgent;
        var browser = navigator.appName;
        var version = '' + parseFloat(navigator.appVersion);
        var majorVersion = parseInt(navigator.appVersion, 10);
        var nameOffset, verOffset, ix;
       
        // browserSettings 
        var browserSettings = {};
  
        // Opera
        if ((verOffset = nAgt.indexOf('Opera')) != -1) {
            browser = 'opera';
            version = nAgt.substring(verOffset + 6);
            if ((verOffset = nAgt.indexOf('Version')) != -1) {
                version = nAgt.substring(verOffset + 8);
            }
        }
        // Opera Next
        if ((verOffset = nAgt.indexOf('OPR')) != -1) {
            browser = 'opera next';
            version = nAgt.substring(verOffset + 4);
        }
        // Edge
        else if ((/Edg/.test(nAgt)) === true) {
            browser = 'edge';
            version = nAgt.substring(verOffset + 5);
        }
        // MSIE
        else if ((verOffset = nAgt.indexOf('MSIE')) != -1) {
            browser = 'msie';
            version = nAgt.substring(verOffset + 5);
        }
        // Chrome
        else if ((verOffset = nAgt.indexOf('Chrome')) != -1) {
            browser = 'chrome';
            version = nAgt.substring(verOffset + 7);
        }
        // Safari
        else if ((verOffset = nAgt.indexOf('Safari')) != -1) {
            browser = 'safari';
            version = nAgt.substring(verOffset + 7);
            if ((verOffset = nAgt.indexOf('Version')) != -1) {
                version = nAgt.substring(verOffset + 8);
            }
        }
        // Firefox
        else if ((verOffset = nAgt.indexOf('Firefox')) != -1) {
            browser = 'firefox';
            version = nAgt.substring(verOffset + 8);
        }
        // MSIE 11+
        else if (nAgt.indexOf('Trident/') != -1) {
            browser = 'ie11';
            version = nAgt.substring(nAgt.indexOf('rv:') + 3);
        }
        // Other browsers
        else if ((nameOffset = nAgt.lastIndexOf(' ') + 1) < (verOffset = nAgt.lastIndexOf('/'))) {
            browser = nAgt.substring(nameOffset, verOffset);
            version = nAgt.substring(verOffset + 1);
            if (browser.toLowerCase() == browser.toUpperCase()) {
                browser = navigator.appName;
            }
        }
        // trim the version string
        if ((ix = version.indexOf(';')) != -1) version = version.substring(0, ix);
        if ((ix = version.indexOf(' ')) != -1) version = version.substring(0, ix);
        if ((ix = version.indexOf(')')) != -1) version = version.substring(0, ix);
  
        majorVersion = parseInt('' + version, 10);
        if (isNaN(majorVersion)) {
            version = '' + parseFloat(navigator.appVersion);
            majorVersion = parseInt(navigator.appVersion, 10);
        }
  
        // mobile version
        var mobile = /Mobile|mini|Fennec|Android|iP(ad|od|hone)/.test(nVer);
  
        // cookie
        var cookieEnabled = (navigator.cookieEnabled) ? true : false;
  
        if (typeof navigator.cookieEnabled == 'undefined' && !cookieEnabled) {
            document.cookie = 'testcookie';
            cookieEnabled = (document.cookie.indexOf('testcookie') != -1) ? true : false;
        }
  
        // system
        var os = unknown;
        var clientStrings = [
            {s:'windows-10', r:/(Windows 10.0|Windows NT 10.0)/},
            {s:'windows-8_1', r:/(Windows 8.1|Windows NT 6.3)/},
            {s:'windows-8', r:/(Windows 8|Windows NT 6.2)/},
            {s:'windows-7', r:/(Windows 7|Windows NT 6.1)/},
            {s:'android', r:/Android/},
            {s:'linux', r:/(Linux|X11)/},
            {s:'iOS', r:/(iPhone|iPad|iPod)/},
            {s:'mac', r:/Mac OS X/},
            {s:'mac-os-old', r:/(MacPPC|MacIntel|Mac_PowerPC|Macintosh)/},
            {s:'unix', r:/UNIX/},
            {s:'search-bot', r:/(nuhk|Googlebot|Yammybot|Openbot|Slurp|MSNBot|Ask Jeeves\/Teoma|ia_archiver)/}
        ];
        for (var id in clientStrings) {
            var cs = clientStrings[id];
            if (cs.r.test(nAgt)) {
                os = cs.s;
                break;
            }
        }
  
        var osVersion = unknown;
  
        if (/Windows/.test(os)) {
            osVersion = /Windows (.*)/.exec(os)[1];
            os = 'windows';
        }
  
        switch (os) {
            case 'mac':
                osVersion = os + '-' +  /Mac OS X (10[\.\_\d]+)/.exec(nAgt)[1];
                break;
  
            case 'android':
                osVersion =  os + '-' +  /Android ([\.\_\d]+)/.exec(nAgt)[1];
                break;
  
            case 'iOS':
                osVersion = /OS (\d+)_(\d+)_?(\d+)?/.exec(nVer);
                osVersion = os + '-' + osVersion[1] + '.' + osVersion[2] + '.' + (osVersion[3] | 0);
                break;

        } 
    }
    browserSettings = {
        os: os,
        version: osVersion,
        mobile: mobile,
        browser: browser,
        cookiesEnabled: cookieEnabled
    }
  
    document.querySelector('body').className += ' ' + os;
    document.querySelector('body').className += ' ' + browser;
    
  }(this));
    