var chipInputs = document.getElementsByClassName('bh-chip-input');

//toggle selected state
for (var i = 0; i < chipInputs.length; i++) {
    chipInputs[i].addEventListener('click', function(event) {

        if (this.parentNode.parentNode.hasAttribute('data-bh-single-selection')) {
            console.log('only one can be chosen!');

            var chipsInGroup = this.parentNode.querySelectorAll('.bh-chip-input'),
                checksInGroup = this.parentNode.querySelectorAll('.bh-selected-icon'),
                chipParent = this.parentNode;

            for (var i = 0; i < chipsInGroup.length; i++) {
                chipsInGroup[i].classList.remove('selected');
            }

            for (var i = 0; i < checksInGroup.length; i++) {
                checksInGroup[i].remove();
            }
        }

        this.classList.toggle('selected');

        //adding the checkmark to the selected state, removing it from the unselected state
        if (this.classList.contains('selected')) {
            var icon = '<svg class="bh-selected-icon" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><polygon fill="#ffffff" fill-rule="nonzero" points="8.785 15.885 4.615 11.715 3.2 13.13 8.785 18.715 20.785 6.715 19.37 5.3"></polygon></g></svg>';

            if (this.classList.contains('bh-chip-input-image')) {
                this.querySelector('.bh-chip-input-image-text').innerHTML = icon + this.querySelector('.bh-chip-input-image-text').innerHTML;
            } else {
                this.innerHTML = icon + this.innerHTML;
            }
        } else {
            if (this.classList.contains('bh-chip-input-image')) {
                this.querySelector('.bh-chip-input-image-text').removeChild(this.querySelector('.bh-selected-icon'));
            } else {
                this.removeChild(this.querySelector('.bh-selected-icon'));
            }
        }

        //check if this input chip is part of a group that counts up the chips
        if (this.parentNode.parentNode.querySelector('.bh-chip-input-group-submit')) {
            countSelectedChips(this);
        }
    });
}

var countSelectedChips = function(lastSelectedChip) {
    var formGroupSubmit = lastSelectedChip.parentNode.parentNode.querySelector('.bh-chip-input-group-submit'),
        selectedChips = lastSelectedChip.parentNode.parentNode.querySelectorAll('.bh-chip-input.selected');

    formGroupSubmit.innerHTML = 'Submit (' + selectedChips.length + ')';

    if (selectedChips.length > 0) {
        formGroupSubmit.disabled = false;
    } else {
        formGroupSubmit.disabled = true;
        formGroupSubmit.innerHTML = 'Submit';
    }
}