var editButtons = document.querySelectorAll('.bh-conversation-bubble-edit-button');

if (editButtons) {
    editButtons.forEach(item => {
        item.addEventListener('click', event => {
            toggleEditButton(event.target);
        })
    })
}

var toggleEditButton = function (button) {

  // Toggle Edit Button
  button.toggleAttribute('disabled');

  // Toggle Class Button
  button.classList.toggle('edit-disabled');

  // Add Disabled Class to User Bubble
  button.previousElementSibling.classList.toggle('disabled');

  // Change 'Edit' to 'Editing Response...' 
  if (button.classList.contains('edit-disabled')) {
    button.textContent = 'Editing response...';
  } else {
    button.textContent = 'Edit';
  }
};

// Note: Add the id 'bh-conversation-save' to the "Editing response" modal's save button
var saveButton = document.getElementById('bh-conversation-save');

if (saveButton) {
  saveButton.addEventListener('click', function (e) {
    toggleEditButton(document.querySelector('.edit-disabled'));
  });
}