var filterGroup = document.querySelector('.bh-filter-group'),
    filterTriggerButtons = document.querySelectorAll('.bh-filter-trigger'),
    filterTriggerButtonMobile = document.querySelector('.bh-filter-mobile-filters-all'),
    filterModals = document.querySelectorAll('.bh-filter-modal'),
    filterInputs = document.querySelectorAll('.bh-filter-input'),
    filterClearButtons = document.querySelectorAll('.bh-filter-clear-button'),
    filterSaveButtons = document.querySelectorAll('.bh-filter-save-button'),
    filterCloseButtonMobile = document.querySelector('.mobile-filter-close'),
    filterApplyButtonMobile = document.querySelector('.bh-filter-apply-button'),
    filterTogglesMobile = document.querySelectorAll('.bh-filter-title-mobile'),
    filterClearButtonMobile = document.querySelector('.mobile-filter-clear'),
    multiColumnHeight;

//open/close modal
var toggleModal = function() {

    //save+close other modals before opening new one
    for (var i = 0; i < filterTriggerButtons.length; i++) {
        if (filterTriggerButtons[i] !== event.target
            && filterTriggerButtons[i].classList.contains('open')) {
                filterTriggerButtons[i].classList.remove('open');
                filterTriggerButtons[i].setAttribute('aria-expanded', false);
                //backend dev - run function to actually filter list here
                alert(filterTriggerButtons[i].getAttribute('id') + ' would be applied here!');
        }
    }

    for (var i = 0; i < filterModals.length; i++) {
        if (filterModals[i].previousElementSibling !== event.target
            && filterModals[i].classList.contains('open')) {
                filterModals[i].classList.remove('open');
        }
    }

    var thisModal = this.nextElementSibling;
    thisModal.classList.toggle('open');
    this.classList.toggle('open');

    if (thisModal.classList.contains('open')) {
        this.setAttribute('aria-expanded', true);
    } else {
        this.setAttribute('aria-expanded', false);

        //backend dev - run function to actually filter list here
        alert(thisModal.previousElementSibling.getAttribute('id') + ' would be applied here!');
    }
}

for (var i = 0; i < filterTriggerButtons.length; i++) {
    filterTriggerButtons[i].addEventListener('click', toggleModal);
}

//save modal (close it)
var saveModal = function(evt) {
    if (evt.target.classList.contains('bh-filter-save-button')) {
        var thisModal = this.parentNode.parentNode,
            thisModalTrigger = this.parentNode.parentNode.previousElementSibling;
    } else {
        var thisModal = document.querySelector('.bh-filter-modal.open'),
            thisModalTrigger = thisModal.previousElementSibling;
    }

    thisModal.classList.remove('open');
    thisModalTrigger.classList.remove('open');

    //backend dev - run function to actually filter list here
    alert(thisModalTrigger.getAttribute('id') + ' would be applied here!');
}

for (var i = 0; i < filterSaveButtons.length; i++) {
    filterSaveButtons[i].addEventListener('click', saveModal);
} 

//if a filter group exists on the page (and a filter modal is open), and clicking outside of the modal, save + close it
document.body.addEventListener('click', function(evt) {
    if (filterGroup
        && !evt.target.classList.contains('bh-filter-trigger')
        && !filterGroup.contains(evt.target)
        && document.querySelector('.bh-filter-modal.open')) {
            saveModal(evt);
    }
});

//update trigger button text based on number checked
var countFilters = function() {
    var thisTrigger = event.target.parentNode.parentNode.parentNode.parentNode.querySelector('.bh-filter-trigger'),
        thisTriggerMobile = event.target.parentNode.parentNode.parentNode.querySelector('.bh-filter-name'),
        buttonText = thisTrigger.innerHTML,
        buttonTextMobile = thisTriggerMobile.innerHTML,
        countSpan = thisTrigger.querySelector('.bh-filter-count'),
        countSpanMobile = thisTriggerMobile.querySelector('.bh-filter-count-mobile'),
        clearButton = event.target.parentNode.parentNode.nextElementSibling.querySelector('.bh-filter-clear-button'),
        clearButtonMobile = document.querySelector('.mobile-filter-clear');

        if (thisTrigger.contains(countSpan) || thisTriggerMobile.contains(countSpanMobile)) {
            var individualCount = thisTrigger.nextElementSibling.querySelectorAll('.bh-filter-input:checked').length;
            countSpan.style.display = 'inline';
            countSpan.innerHTML = ' (' + individualCount + ')';
            countSpanMobile.style.display = 'inline';
            countSpanMobile.innerHTML = ' (' + individualCount + ')';

            if (individualCount < 1) {
                countSpan.style.display = 'none';
                countSpanMobile.style.display = 'none';
                clearButton.setAttribute('disabled', true);
                clearButtonMobile.setAttribute('disabled', true);
            } else {
                clearButton.removeAttribute('disabled');
                clearButtonMobile.removeAttribute('disabled');
            }
            
        } else {
            var individualCount = thisTrigger.nextElementSibling.querySelectorAll('.bh-filter-input:checked').length;
            buttonText = buttonText + '<span class="bh-filter-count"> (' + individualCount + ')</span>';
            buttonTextMobile = buttonTextMobile + '<span class="bh-filter-count-mobile"> (' + individualCount + ')</span>';
            thisTrigger.innerHTML = buttonText;
            thisTriggerMobile.innerHTML = buttonTextMobile;
            clearButton.removeAttribute('disabled');
            clearButtonMobile.removeAttribute('disabled');
        }

}

for (var i = 0; i < filterInputs.length; i++) {
    filterInputs[i].addEventListener('change', function(event) {
        countFilters(event);
    });
}

//close mobile filter modal
var closeModalMobile = function () {
    var mobileModal = document.querySelector('.bh-filter-group'),
        applyWasClicked = this == document.querySelector('.bh-filter-apply-button');
    filterTriggerButtonMobile.classList.remove('open');
    mobileModal.classList.remove('open'); 

    if (applyWasClicked) {
        //backend dev - run function to actually filter list here
        alert('All filters would be applied here!');
    }
}

//clear all checkboxes
var clearFilters = function() {
    var thisModal = this.parentNode.parentNode,
        filterCheckboxes = thisModal.querySelectorAll('.bh-filter-input'), 
        thisTrigger = this.parentNode.parentNode.parentNode.querySelector('.bh-filter-trigger'),
        thisTriggerMobile = this.parentNode.parentNode.querySelector('.bh-filter-name');

    for (var i = 0; i < filterCheckboxes.length; i++) {
        filterCheckboxes[i].checked = false;
        filterCheckboxes[i].setAttribute('aria-checked', false);
    }

    thisTrigger.querySelector('.bh-filter-count').innerHTML = '';
    thisTrigger.querySelector('.bh-filter-count').style.display = 'none';
    thisTriggerMobile.querySelector('.bh-filter-count-mobile').innerHTML = '';
    thisTriggerMobile.querySelector('.bh-filter-count-mobile').style.display = 'none';
    this.setAttribute('disabled', true);
    
    if (document.querySelectorAll('.bh-filter-input:checked').length == 0) {
        filterClearButtonMobile.setAttribute('disabled', true);
    }
}

for (var i = 0; i < filterClearButtons.length; i++) {
    filterClearButtons[i].addEventListener('click', clearFilters);
}

var clearFiltersMobile = function () {
    var thisModal = this.parentNode.parentNode.parentNode,
        filterCheckboxes = thisModal.querySelectorAll('.bh-filter-input'),
        filterCounts = thisModal.querySelectorAll('.bh-filter-count'),
        filterCountsMobile = thisModal.querySelectorAll('.bh-filter-count-mobile');

    filterClearButtonMobile.setAttribute('disabled', true);

    for (var i = 0; i < filterCheckboxes.length; i++) {
        filterCheckboxes[i].checked = false;
        filterCheckboxes[i].setAttribute('aria-checked', false);
    }

    for (var i = 0; i < filterCounts.length; i++) {
        filterCounts[i].innerHTML = '';
        filterCounts[i].style.display = 'none';
    }

    for (var i = 0; i < filterCountsMobile.length; i++) {
        filterCountsMobile[i].innerHTML = '';
        filterCountsMobile[i].style.display = 'none';
    }
}

//show/hide filter groups on mobile
var toggleFilterMobile = function () {
    var listToToggle = this.nextElementSibling;
    if (listToToggle.style.display === 'none') {
        listToToggle.style.display = 'block';
    } else {
        listToToggle.style.display = 'none';
    }
    this.classList.toggle('open');
}

for (var i = 0; i < filterTogglesMobile.length; i++) {
    filterTogglesMobile[i].addEventListener('click', toggleFilterMobile);
}

//check if filter is flowing off the screen
var checkFilterBottomOverflow = function () {
    //check if on desktop and a modal is actually open
    if (window.innerWidth > 767 && document.querySelector('.bh-filter-modal.open')) {
        var openFilterModal = document.querySelector('.bh-filter-modal.open'),
            filterTop = openFilterModal.getBoundingClientRect().top,
            filterBottom = openFilterModal.getBoundingClientRect().bottom,
            screenBottomBarrier = window.innerHeight - 24,
            isAlreadyScrollingFilter = openFilterModal.classList.contains('scrolling-checkbox');

        if (filterBottom >= screenBottomBarrier) {
            openFilterModal.classList.add('scrolling-checkbox');

            if (openFilterModal.classList.contains('multi-column')) {
                openFilterModal.classList.remove('multi-column');
                openFilterModal.classList.add('had-multi-column');
                multiColumnHeight = openFilterModal.getBoundingClientRect().height;
            }

            openFilterModal.style.maxHeight = `calc(100vh - ${filterTop + 22}px)`;

        } else {
            if (window.innerHeight > 420) {
                openFilterModal.classList.remove('scrolling-checkbox');

                if (openFilterModal.classList.contains('had-multi-column')) {
                    openFilterModal.classList.add('multi-column');
                    openFilterModal.classList.remove('had-multi-column');
                }
            }
        }
        
        if (openFilterModal.classList.contains('had-multi-column') && isAlreadyScrollingFilter) {
            if (openFilterModal.getBoundingClientRect().height > multiColumnHeight) {
                openFilterModal.classList.remove('scrolling-checkbox');
                openFilterModal.classList.add('multi-column');
                openFilterModal.classList.remove('had-multi-column');
            }
        }
    }
}

//event listeners for filters
if (filterGroup) {
    filterCloseButtonMobile.addEventListener('click', closeModalMobile);
    filterApplyButtonMobile.addEventListener('click', closeModalMobile);
    filterClearButtonMobile.addEventListener('click', clearFiltersMobile);

    for (var i = 0; i < filterTriggerButtons.length; i++) {
        filterTriggerButtons[i].addEventListener('click', checkFilterBottomOverflow);
    }

    window.addEventListener('resize', checkFilterBottomOverflow);
}