const audienceToggles = document.querySelectorAll('.site-search-results-classes-events-toggle'),
      classEventCards = document.querySelectorAll('.site-search-results-classes-events-card, .site-search-results-classes-events .site-search-results-api-error-card');
 
audienceToggles.forEach(function(audienceToggle) {
    //when clicking audience toggle, show only cards with that audience type
    audienceToggle.addEventListener('click', function() {
        const audienceTypeClicked = audienceToggle.dataset.audienceTypeToggle,
              audienceButtonsClicked = document.querySelectorAll(`[data-audience-type-toggle="${audienceTypeClicked}"]`),
              cardsWithAudienceTypes = document.querySelectorAll(`[data-audience-type="${audienceTypeClicked}"]`);
        

        //hide all cards   
        audienceToggles.forEach(function(audienceToggle) {
            audienceToggle.classList.remove('bh-chip--selected');
        }); 
        classEventCards.forEach(function(card) {
            card.style.display = 'none';
        });

        //show relevant cards
        audienceButtonsClicked.forEach(function(button) {
            button.classList.add('bh-chip--selected');
        }); 
        cardsWithAudienceTypes.forEach(function(card) {
            card.style.display = 'block';
        });
    });
});

