// Add current class to link on select
const globalEventListener = (type, selector, callback) => {
  document.addEventListener(type, (event) => {
    if (event.target.matches(selector)) {
      callback(event);
    }
  });
};

globalEventListener("click", "a.site-search-menu-link", (event) => {
  // Remove Current Class of Menu Link
  const currentLink = event.target;
  const menuLinks = document.querySelectorAll("a.site-search-menu-link");
  menuLinks.forEach((link) => {
    link.classList.remove("site-search-menu-link--current");
  });

  // Add Class to Selected Link:
  currentLink.classList.add("site-search-menu-link--current");
  currentLink.blur();
});
