$(document).ready(function () {
    //below numbers are references to each column in table
    const colDate = 0,
         colCase = 1,
         colPatientName = 2,
         colAge = 3,
         colCondition = 4,
         colStatus = 5,
         colDetails = 6,
         colStatusText = 7,
         colYearText = 8,
         draftCount = document.querySelectorAll('.bh-provider-case-list-status-badge--draft').length,
         overdueCount = document.querySelectorAll('.bh-provider-case-list-status-badge--overdue').length,
         assignedCount = document.querySelectorAll('.bh-provider-case-list-status-badge--assigned').length,
         submittedCount = document.querySelectorAll('.bh-provider-case-list-status-badge--submitted').length,
         draftBadge = document.querySelector('.bh-checkbox-group-badge--draft'),
         overdueBadge = document.querySelector('.bh-checkbox-group-badge--overdue'),
         assignedBadge = document.querySelector('.bh-checkbox-group-badge--assigned'),
         submittedBadge = document.querySelector('.bh-checkbox-group-badge--submitted');

    if (draftBadge) {
        draftBadge.innerHTML = draftCount;
        overdueBadge.innerHTML = overdueCount;
        assignedBadge.innerHTML = assignedCount;
        submittedBadge.innerHTML = submittedCount;
    }

    const caseListTable = $('#bh-provider-case-list').DataTable({
        'order': [[colDate, 'desc']], //default order: by date, going backwards
        'rowGroup': { //row group headers for status types
            enable: true,
            dataSrc: colYearText,
            className: 'bh-provider-case-list-table-group-header'
        }, 
        'columnDefs': [ 
            { 'orderable': false, 'targets': [colDetails] }, //turns off sorting arrows on certain columns
            { 'searchable': false, 'targets': [colAge, colDetails] }, //disables searching certain columns
            { 'visible': false, 'targets': [colStatusText, colYearText] },//hides status-text column as it's just used for row grouping
        ], 
        'lengthChange': false, //hides "show 10 entries" dropdown
        'autoWidth': false,
        'pagingType': 'simple_numbers',
        'language': {
            'emptyTable': 'No cases in queue.',
            'search': '', 
            'searchPlaceholder': 'Search by condition, case number, patient name, or date.',
            'sInfo': 'Displaying _START_-_END_ of _TOTAL_ cases',
            'sZeroRecords': 'No matching records found.',
            'sInfoEmpty':'Displaying 0 of 0 cases',
            'sInfoFiltered':'',
            'paginate': {
                'previous': '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19 11C19.5523 11 20 11.4477 20 12C20 12.5523 19.5523 13 19 13H8V16L4 12L8 8V11H19Z" fill="#9CA0A5"/></svg> <span>Prev</span>',
                'next': '<span>Next</span> <svg width="16" height="8" viewBox="0 0 16 8" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 3C0.447715 3 0 3.44772 0 4C0 4.55228 0.447715 5 1 5H12V8L16 4L12 0V3H1Z" fill="#303235"/></svg>'
            },
            'aria': {
                'paginate': {
                    'previous': 'Previous page',
                    'next': 'Next page'
                }
            }
        },
        //when table loads, more customizations:
            //search only performs if at least 3 characters are in search
            //if no cases are in the queue, adds a class for styling 
        'initComplete': function () {
            if ($(this).find('tbody tr').length<=1) {
                $('.bh-provider-case-list').addClass('no-cases');
            } else {
                $('.dataTables_filter input')
                .off() // unbind previous default bindings
                .on('input', function (e) {
                    if(this.value.length >= 3) {
                        caseListTable.search(this.value).draw();
                    }
                    if(this.value == '') {
                        caseListTable.search('').draw();
                    }
                    return;
                }); 
            }
        },
        //function called when table loads and after each search/filter application
        'drawCallback': function(settings) {
            const api = this.api(),
                  filteredResultCount = api.data().rows( {search:'applied'} ).count();

            if (filteredResultCount == 0) {
                $('.bh-provider-case-list').addClass('no-results-found');

                $('.dataTables_paginate > span').html('<a class="paginate_button disabled" aria-controls="bh-provider-case-list" data-dt-idx="1" tabindex="-1" disabled="">1</a>');
            }
        }
    });

    //scroll to top of table on page change
    $('#bh-provider-case-list').on('page.dt', function () {
        $('html, body').animate({
            scrollTop: $('.bh-provider-case-list').offset().top
        }, 200);        
    });
    
    const sortButton = document.querySelector('.bh-provider-case-list-sort-button'),
        sortButtonCount = document.querySelector('.bh-provider-case-list-filter-count'),
        sortModal = document.querySelector('.bh-provider-case-list-modal'),
        clearButton = document.querySelector('.bh-outlined-1-button-clear'),
        closeButton = document.querySelector('.bh-provider-case-list-modal-close'),
        applyButton = document.querySelector('.bh-primary-button-apply'),
        statusCheckboxes = document.querySelectorAll('.bh-provider-case-list-modal-status-group .bh-checkbox-group-input'),
        mobileTableBp = 640;

    let statusesRegex = 'draft|overdue|assigned|submitted';

    const openSortModal = function() {
        sortModal.classList.add('open');
    }

    const closeSortModal = function() {
        sortModal.classList.remove('open');
    }

    const applySortModal = function() {
        const sortValue = document.querySelector('input[name="bh-sort"]:checked').value;

        //"Sort by" most recent (date) or status radio button, also change the grouping source for mobile
        let columnToSort;
        if (sortValue == 'status') {
            columnToSort = 5;
            $('#bh-provider-case-list').DataTable().rowGroup().dataSrc(colStatusText);
        } else {
            columnToSort = 0;
            $('#bh-provider-case-list').DataTable().rowGroup().dataSrc(colYearText);
        }
        
        caseListTable.order( [[ columnToSort, 'desc' ]] );

        //"Status" checkboxes to update table search
        const checkedStatusCheckboxes = document.querySelectorAll('.bh-provider-case-list-modal-status-group .bh-checkbox-group-input:checked');

        statusesRegex = '';

        if (checkedStatusCheckboxes.length > 0) {
            checkedStatusCheckboxes.forEach(function(statusCheckbox) {
                const status = statusCheckbox.value;
                statusesRegex += status + '|';
            });
            caseListTable.column(colStatus).search(statusesRegex.slice(0, -1), true, false).draw();
        } else {
            caseListTable.column(colStatus).search('noresultsfound', false, false).draw();
        }

        closeSortModal();
    }

    const setStatusCounts = function() {
        const checkedStatusCheckboxes = document.querySelectorAll('.bh-provider-case-list-modal-status-group .bh-checkbox-group-input:checked'),
              applyButtonCount = document.querySelector('.bh-primary-button-apply-count');

        let totalStatusesCount = 0;

        checkedStatusCheckboxes.forEach(function(statusCheckbox) {
            const count = statusCheckbox.parentElement.querySelector('.bh-checkbox-group-badge').innerHTML;
            totalStatusesCount += Number(count);
        });

        applyButtonCount.innerHTML = totalStatusesCount;
    }

    if (sortButton) {
        sortButton.addEventListener('click', function() {
            if (sortModal.classList.contains('open')) {
                closeSortModal();   
            } else {
                openSortModal();
                setStatusCounts();
            }
        });
    

        closeButton.addEventListener('click', function() {
            closeSortModal();
        });

        clearButton.addEventListener('click', function() {
            statusCheckboxes.forEach(function(statusCheckbox){
                statusCheckbox.checked = false;
            });
            setStatusCounts();
            sortButtonCount.innerHTML = '0';
        });

        applyButton.addEventListener('click', function() {
            applySortModal();
        });
    }

    statusCheckboxes.forEach(function(statusCheckbox){
        statusCheckbox.addEventListener('click', function() {
            const checkedStatusCheckboxes = document.querySelectorAll('.bh-provider-case-list-modal-status-group .bh-checkbox-group-input:checked').length;
            sortButtonCount.innerHTML = checkedStatusCheckboxes;
            setStatusCounts();
        });
    });

});