var emails = document.querySelectorAll('.bh-text-input-field-input-email');

var emailChecker = (email) => {
  const emailValue = email.value;

  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(emailValue)) {
    email.parentElement.classList.remove('bh-form-field-error');
    return true;
  }

  email.parentElement.classList.add('bh-form-field-error');
  return false;
};

for (let email of emails) {
  email.addEventListener('blur', (e) => {
    emailChecker(e.target);
  });
}
