var charCountFieldsets = document.getElementsByClassName('bh-text-input-textarea--char-count');

for (var i = 0; i < charCountFieldsets.length; i++) {
    var fieldset = charCountFieldsets[i];
    var textarea = fieldset.querySelector('textarea');
    
    var updateCharMsg = function (activeTextarea) {
        var strLength = activeTextarea.value.length;
        var maxChars = activeTextarea.getAttribute('data-max-char-count');
        var charRemain = maxChars - strLength;
        var exceedAmt = strLength - maxChars;
        var charCountMsg = activeTextarea.parentNode.nextElementSibling;
        if (charRemain < 0) {
            charCountMsg.innerHTML = 'You have exceeded the character limit by <span style="color: #da291c;">' + exceedAmt + '</span>.';
            activeTextarea.classList.add('over-limit');
        } else {
            charCountMsg.innerHTML = 'Characters left ' + charRemain + '.';
            activeTextarea.classList.remove('over-limit');
            charCountMsg.classList.remove("bh-text-input-field-error");
        }
    }
    
    textarea.addEventListener('focus', function() {
        var fieldset = this.parentNode.parentNode;
        var charCountMsg = this.parentNode.nextElementSibling;
        charCountMsg.style.display = 'block';
        fieldset.classList.remove('bh-form-field-error')
        this.classList.remove('bh-text-input-field-error');
        updateCharMsg(this);
    });
    
    textarea.addEventListener('keyup', function() {
        updateCharMsg(this);
    });
    textarea.addEventListener('blur', function() {
        var strLength = this.value.length;
        var fieldset = this.parentNode.parentNode;
        var charCountMsg = this.parentNode.nextElementSibling;
        var genericErrorMsg = charCountMsg.nextElementSibling;
        if (strLength == 0 || this.classList.contains('over-limit')) {
            fieldset.classList.add('bh-form-field-error');
            charCountMsg.classList.add('bh-text-input-field-error');
            if (strLength == 0) {
                charCountMsg.innerHTML = genericErrorMsg.innerHTML;
            }
        } else {
            fieldset.classList.remove('bh-form-field-error');
            charCountMsg.classList.remove('bh-text-input-field-error');
        }
    });
}