window.addEventListener("load", function () {
  function validateZipCode(elementValue) {
    var zipCodePattern = /^\d{5}$|^\d{5}-\d{4}$/;
    return zipCodePattern.test(elementValue);
  }
  var zipcode = document.querySelector(".bh-text-input-field-zipcode");

  if (zipcode) {
    zipcode.addEventListener("submit", function (e) {
      if (validateZipCode(document.querySelector("#zipcode-input").value)) {
        if (
          document
            .querySelector(".bh-text-input-field-zipcode .bh-text-input-field")
            .classList.contains("bh-form-field-error")
        ) {
          document
            .querySelector(".bh-text-input-field-zipcode .bh-text-input-field")
            .classList.remove("bh-form-field-error");
        }
      } else {
        e.preventDefault();
        document
          .querySelector(".bh-text-input-field-zipcode .bh-text-input-field")
          .classList.add("bh-form-field-error");
      }
    });
  }
});
